import styles from "./index.module.scss";
import Layout from "~/components/layout";
import { Space, Image as AImage, Row, Col, Button, Divider, Badge } from "antd";
import { useEffect, useState } from "react";
import { RightOutlined } from "@ant-design/icons";
import Image from "next/image";
import errImg from "~/assets/errImg";
import { useRouter } from "next/router";
// Import Swiper React components
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation } from "swiper";

// Import Swiper styles
import "swiper/css";
import "swiper/css/navigation";
import api, { GetAppGoodsInfoDetailResult } from "./api";

export default function MallDetail() {
  const [visible, setVisible] = useState(false);
  const router = useRouter();
  const [id, setId] = useState<number | null>(null);
  const [detail, setDetail] = useState<GetAppGoodsInfoDetailResult | null>(
    null
  );

  useEffect(() => {
    setId(Number(router.query.id));
  }, [router]);

  useEffect(() => {
    if (id) {
      api
        .getAppGoodsInfoDetail({
          id: id,
        })
        .then((res) => {
          setDetail(res.result || null);
        });
    }
  }, [id]);

  return (
    <Layout>
      <div className="page" style={{ marginTop: 20, backgroundColor: "#fff" }}>
        <div style={{ display: "none" }}>
          <AImage.PreviewGroup
            preview={{ visible, onVisibleChange: (vis) => setVisible(vis) }}
          >
            {detail?.images?.map((item) => {
              return <AImage key={item.id} src={item.imgUrl} />;
            })}
          </AImage.PreviewGroup>
        </div>
        <Space size={30} style={{ padding: "22px 24px 0" }}>
          {/* 商品图 */}
          <Space size={17} direction="vertical" style={{ width: 300 }}>
            <AImage
              preview={{ visible: false }}
              width={300}
              height={300}
              src={detail?.images && detail.images[0].imgUrl}
              onClick={() => setVisible(true)}
              fallback={errImg}
            />
            <Swiper
              modules={[Navigation]}
              spaceBetween={6}
              slidesPerView={5}
              onSlideChange={() => console.log("slide change")}
              onSwiper={(swiper) => console.log(swiper)}
            >
              {detail?.images?.map((item) => {
                return (
                  <SwiperSlide key={item.id}>
                    <AImage
                      preview={false}
                      width={50}
                      height={50}
                      src={item.imgUrl}
                      fallback={errImg}
                    />
                  </SwiperSlide>
                );
              })}
            </Swiper>
          </Space>

          <Space direction="vertical" size={17}>
            <div className={`${styles.font1} ${styles.ellipsis}`}>
              {detail?.goodsName}
            </div>
            <div className={`${styles.font2} ${styles.ellipsis}`} style={{height: 22}}>
              {detail?.goodsDesc}
            </div>
            <Space
              size={24}
              direction="vertical"
              style={{
                padding: "24px 40px 24px 0",
                width: 470,
              }}
            >
              <Row wrap={false}>
                <Col flex="60px" className={styles.font3}>
                  选择
                </Col>
                <Col
                  flex="auto"
                  className={styles.font4}
                  style={{ cursor: "pointer" }}
                >
                  已选：1件
                </Col>
              </Row>
              <Row wrap={false}>
                <Col flex="60px" className={styles.font3}>
                  送至
                </Col>
                <Col flex="auto" style={{ cursor: "pointer" }}>
                  <Space size={5}>
                    <Image
                      alt=""
                      width={18}
                      height={18}
                      src={require("./assets/locate.png")}
                    ></Image>
                    <span className={`${styles.font3} ${styles.ellipsis}`}>
                      广东深圳市南山区万科云城创新谷6栋A座…
                    </span>
                  </Space>
                  <div className={styles.font4} style={{ marginTop: 7 }}>
                    现货，22:00前下单，预计后天（8月30日）送达
                  </div>
                </Col>
              </Row>
            </Space>
            <Space size={12} style={{ marginTop: 20 }}>
              <Button className={styles.btn1}>加入购物车</Button>
              <Button className={styles.btn2} type="primary">
                提交意向
              </Button>
              <Space size={20} style={{ marginLeft: 19 }}>
                <div style={{ textAlign: "center", cursor: "pointer" }}>
                  <Image
                    alt=""
                    src={require("./assets/phone.png")}
                    width={20}
                    height={20}
                  ></Image>
                  <div className={styles.font5} style={{ marginTop: 5 }}>
                    电话
                  </div>
                </div>
                <div style={{ textAlign: "center", cursor: "pointer" }}>
                  <Badge count={55} size="small">
                    <Image
                      alt=""
                      src={require("./assets/car.png")}
                      width={20}
                      height={20}
                    ></Image>
                  </Badge>
                  <div className={styles.font5} style={{ marginTop: 5 }}>
                    购物车
                  </div>
                </div>
              </Space>
            </Space>
          </Space>
        </Space>
        <Divider className={styles.divider}>商品详情</Divider>
        <div style={{ textAlign: "center" }}>
          <div
            dangerouslySetInnerHTML={{
              __html: detail?.goodsDetail?.content || "",
            }}
          ></div>
        </div>
      </div>
    </Layout>
  );
}
